/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIIODescriptionLookup {
    private static final String CLASS_CODE_BUNDLE = "HscPciClassCodeInfo";
    private static final String IO_ADAPTER_BUNDLE = "IOAdapterBundle";
    private static final String I_CCIN_MAP = "/opt/hsc/data/iCCINKeys";
    private static final String I_FC_MAP = "/opt/hsc/data/iFCKeys";
    private static final String FC_MAP = "/opt/hsc/data/FCKeys";
    private static final String UNKNOWN = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "UNKNOWN");
    private static final int GROUP = 0;
    private static Map m_classCodes = new HashMap();
    private static Map m_featureCodes = new HashMap();
    private static Map m_ifeatureCodes = new HashMap();
    private static Map m_iccins = new HashMap();
    private static Properties m_iFCToKey = null;
    private static Properties m_FCToKey = null;
    private static Properties m_iCCINToKey = null;
    private boolean m_isiSeries;

    public PIIODescriptionLookup(UnsignedInt16 unsignedInt16) throws IOException {
        this.m_isiSeries = PIHscUtil.isISeriesBrand(unsignedInt16);
        if (m_iFCToKey == null) {
            m_iFCToKey = new Properties();
            m_iFCToKey.load(new FileInputStream(I_FC_MAP));
        }
        if (m_FCToKey == null) {
            m_FCToKey = new Properties();
            m_FCToKey.load(new FileInputStream(FC_MAP));
        }
        if (m_iCCINToKey == null) {
            m_iCCINToKey = new Properties();
            m_iCCINToKey.load(new FileInputStream(I_CCIN_MAP));
        }
    }

    public String lookupClassCode(UnsignedInt16 unsignedInt16) {
        int n = unsignedInt16.intValue();
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        return this.lookupClassCode(n2, n3);
    }

    public String lookupClassCode(UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8) {
        int n = unsignedInt16.intValue();
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        return this.lookupClassCode(n2, n3, unsignedInt8.intValue());
    }

    public String lookupFeatureCode(String string) {
        String string2;
        String string3 = (String)m_featureCodes.get(string);
        if (string3 != null) {
            return string3;
        }
        if (!this.m_isiSeries) {
            string2 = m_FCToKey.getProperty(string);
            if (string2 != null) {
                string2 = string2.trim();
            }
            string3 = HSCResourceBundleUtil.getMessage(IO_ADAPTER_BUNDLE, string2, UNKNOWN);
        }
        if (this.m_isiSeries || UNKNOWN.equals(string3)) {
            string2 = m_iFCToKey.getProperty(string);
            if (string2 != null) {
                string2 = string2.trim();
            }
            string3 = HSCResourceBundleUtil.getMessage(IO_ADAPTER_BUNDLE, string2, UNKNOWN);
        }
        m_featureCodes.put(string, string3);
        return string3;
    }

    public String lookupCCIN(String string) {
        String string2 = (String)m_iccins.get(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = m_iCCINToKey.getProperty(string);
        if (string3 != null) {
            string3 = string3.trim();
        }
        string2 = HSCResourceBundleUtil.getMessage(IO_ADAPTER_BUNDLE, string3, UNKNOWN);
        m_iccins.put(string, string2);
        return string2;
    }

    private String buildClassCodeKey(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append(n2).append(n3);
        return stringBuffer.toString();
    }

    private String lookupClassCode(int n, int n2, int n3) {
        String string = this.buildClassCodeKey(n, n2, n3);
        String string2 = this.lookupClassCode(string);
        if (UNKNOWN.equals(string2)) {
            string2 = this.lookupClassCode(n, n2);
        }
        return string2;
    }

    private String lookupClassCode(int n, int n2) {
        String string = this.buildClassCodeKey(n, n2, 0);
        String string2 = this.lookupClassCode(string);
        if (UNKNOWN.equals(string2)) {
            string2 = this.lookupClassCode(n);
        }
        return string2;
    }

    private String lookupClassCode(int n) {
        String string = this.buildClassCodeKey(n, 0, 0);
        String string2 = this.lookupClassCode(string);
        return string2;
    }

    private String lookupClassCode(String string) {
        String string2 = (String)m_classCodes.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = HSCResourceBundleUtil.getMessage(CLASS_CODE_BUNDLE, string, UNKNOWN);
        m_classCodes.put(string, string2);
        return string2;
    }
}

